<?php
include("db.php"); // Include your database connection

// Set content type to JSON
header('Content-Type: application/json');

// Check if Product_id or category is provided in the GET request
if (isset($_GET['Product_id']) || isset($_GET['category'])) {
    // Initialize variables
    $sql = "";

    // Fetch product by Product_id
    if (isset($_GET['Product_id'])) {
        $productId = intval($_GET['Product_id']); // Sanitize and assign Product_id
        $sql = "SELECT * FROM product WHERE Delete_status=0 AND Product_id = $productId";
    } 
    // Fetch products by category
    elseif (isset($_GET['category'])) {
        $category = $conn->real_escape_string($_GET['category']); // Sanitize and assign category
        $sql = "SELECT * FROM product WHERE Delete_status=0 AND category = '$category'";
    }

    // Execute the query
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        // Fetch all matching products
        $products = [];
        while ($row = $result->fetch_assoc()) {
            $products[] = $row;
        }
        echo json_encode(['status' => 'success', 'data' => $products]);
    } else {
        // No product(s) found
        echo json_encode(['status' => 'error', 'message' => 'No products found']);
    }
} else {
    // Neither Product_id nor category provided
    echo json_encode(['status' => 'error', 'message' => 'Product_id or category is required']);
}

$conn->close();
?>
